//AIM:To design Chebyshev filter with minimum readymade Scilab functions

//Design of low pass 1 rad/sec bandwidth Chebyshev filter
//Acceptable passband ripple=2 db
//cut off radian frequency 1 radian/sec
//stop band attenuation of 20db or greater beyond 1.3 radian/sec

//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//Given cut-off frequency is 1 rad/sec. This means that it is a normalized low
//pass Chebyshev filter
fc=1;//from the above question
Ap=2;//from the above question
As=20;//from the above question
ohms=1.3;//from the above question
ohmp=1;//It is a normalized filter.Hence the value is 1 rad/sec

//Steps for calculation of ε
a=(0.1*2)
b=10^a
c=b-1
episelon=c^(1/2)
disp(episelon,"ε=")

//Steps for calculation of order
d=(-20)*((log(episelon)/log(10)))
e=(20)*(log(ohms)/log(10))
f=6+e
g=26+d
N=g/f
Nr=int (N)
x=N-int(N)
if(x>0)
 Nr=Nr+1  
//N=(((-20)*log(episelon))+6+20)/(6+20*(log(ohms)))
D=-20;//given in db
//N=-(20*log10(episelon))-6(N-1)-(20*log(ohms))
h1=((episelon)^2)
h2=1+h1
h3=h2^(1/2)
h4=h3+1
g=(episelon) 
h5=h4/g
beta=(h5)^(1/Nr)
disp(N,"N=")
disp(Nr,"The round-off value of N(now called as Nr)=")
disp(beta,"β=")

//for the determination of poles we have
r=(ohmp)*(((beta^2)-1)/(2*beta))
disp(r,"The minor axis of the ellipse(r)=")
R=ohmp*((beta^2+1)/(2*beta))
disp(R,"The major axis of the ellipse(R)=");
// thetai=(%pi/2)+((2i+%pi)/2*N)// i=0123
// for i=0
theta0=((%pi/2)+((2*0*%pi+%pi)/(2*4)))
disp(theta0,"theta0=")
// for i=1
theta1=((%pi/2)+((2*1*%pi+%pi)/(2*4)))
disp(theta1,"theta1=")
// for i=2
theta2=((%pi/2)+((2*2*%pi+%pi)/(2*4)))
disp(theta2,"theta2=")
// for i=3
theta3=((%pi/2)+((2*3*%pi+%pi)/(2*4)))
disp(theta3,"theta3=")
//the pole position is given by
//sp=r*cos(thetai)+jsin(thetai)
i=0:1:Nr-1
//Computing real and imaginary part of s0,s1,s2,s3
h6=((r)*(cos(theta0))) //Computing real part of s0
h7=(%i)*(R)*(sin(theta0)) //Computing imaginary part of s0
s0=h6+h7; //Combining real and imaginary part of s0
disp(s0,"s0=")
h8=((r)*(cos(theta1))) //Computing real part of s1
h9=(%i)*(R)*(sin(theta1)) //Computing imaginary part of s1
s1=h8+h9; //Combining real and imaginary part of s1
disp(s1,"s1=")
h10=((r)*(cos(theta2))) //Computing real part of s2
h11=(%i)*(R)*(sin(theta2)) //Computing imaginary part of s2
s2=h10+h11; //Combining real and imaginary part of s2
disp(s2,"s2=")
h12=((r)*(cos(theta3))) //Computing real part of s3
h13=(%i)*(R)*(sin(theta3)) //Computing imaginary part of s3
s3=h12+h13; //Combining real and imaginary part of s13
disp(s3,"s3=")

//Calculation of transfer function:
s=poly(0,"s")
h=1/((s-(s0))*(s-(s1))*(s-(s2))*(s-(s3)))
disp(h,"h=")
disp('Now type resume and press enter in the Console window')
pause
//Now value of b0 is required which is nothing but the value of the constant
//term in the denominator of h (obtained by seeing the calculated value in the
//console window by inserting a 'pause' in the program)
b0=0.2057651;
//Also we see in the Console window that the rounded value of the order is 4
//and  since 4 is an even number,so the formula for calculation of i will be 
// i=b0/(sqrt(1+ε^2))
i=b0/(sqrt(1+(episelon)^2))
disp(i,'i=')
Hs=i*h//Calculated value of Ha(s)
disp(Hs,'The required transfer function Ha(s)=') //Displaying the calculated value of the transfer function
